//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.4

import wesual.Ui 1.0

import wesual.data.Core 1.0

FocusScope {
    id : valueStoreEditor

    property SchemaValueStore valueStore
    readonly property Schema schema : valueStore.schema

    implicitWidth  : 200
    implicitHeight : content.implicitHeight

    onSchemaChanged       : content.updateVariables()
    Component.onCompleted : content.updateVariables()

    Column {
        id : content

        property var variables : []

        readonly property int minimumLabelWidth : 30
        readonly property int maximumLabelWidth :
            parseInt(valueStoreEditor.width / 3)
        readonly property int labelWidth : parseInt(Math.max(minimumLabelWidth,
                         Math.min(maximumLabelWidth, preferredLabelWidth)) + 1)
        readonly property int labelSpacing : 12

        property int preferredLabelWidth : 0

        function updateLabelWidth(width) {
            preferredLabelWidth = Math.max(preferredLabelWidth, width);
        }

        function updateVariables() {
            var current = schema;
            var schemas = [];
            var vars = [];

            while (current) {
                schemas.push(current);
                current = current.parentClass;
            }

            while (schemas.length > 0) {
                current = schemas.pop();
                for (var i = 0; i < current.variables.length; ++i) {
                    vars.push(current.variables[i]);
                }
            }
            content.variables = vars;
        }

        width   : valueStoreEditor.width
        spacing : 9

        Repeater {
            model    : content.variables
            delegate : Item {
                id : editorRow

                property Item editor

                readonly property bool labelVisible : editor &&
                    !(editor.displayFlags & SchemaValueEditor.HideLabel)

                width  : valueStoreEditor.width
                implicitHeight : editor ? editor.implicitHeight : 20

                UiLabel {
                    text : modelData.name
                    anchors {
                        left     : parent.left
                        baseline : editor ? editor.baseline : undefined
                    }
                    visible : labelVisible
                    width   : content.labelWidth

                    Component.onCompleted :
                        content.updateLabelWidth(implicitWidth)
                    onImplicitWidthChanged :
                        content.updateLabelWidth(implicitWidth)
                }

                Component.onCompleted : {
                    var comp = modelData.getEditorComponent(
                                SchemaVariable.CondensedValueEditor);
                    if (comp) {
                        editor = comp.createObject(editorRow, {
                            "variable"   : modelData,
                            "valueStore" : Qt.binding(function() {
                                return valueStoreEditor.valueStore;
                            })
                        });
                        if (editor) {
                            editor.anchors.right = editorRow.right;
                            editor.width = Qt.binding(function() {
                                if (editorRow.labelVisible) {
                                    return valueStoreEditor.width -
                                            content.labelWidth -
                                            content.labelSpacing;
                                } else {
                                    return valueStoreEditor.width;
                                }
                            });
                        }
                    }
                }
            }
        }
    }
}
